<?php
// routes/routes.php

require_once dirname(__DIR__) . '/controllers/AuthController.php';
require_once dirname(__DIR__) . '/controllers/BranchesController.php';
require_once dirname(__DIR__) . '/controllers/CompaniesController.php';
require_once dirname(__DIR__) . '/controllers/ComplaintsController.php';
require_once dirname(__DIR__) . '/controllers/ProductsController.php';
require_once dirname(__DIR__) . '/controllers/UserProductsController.php';
require_once dirname(__DIR__) . '/controllers/ProductCategoriesController.php';

require_once dirname(__DIR__) . '/middlewares/AuthMiddleware.php';

function route_request($uri, $method) {
    global $pdo; // تأكد من أن متغير الاتصال بقاعدة البيانات متاح

    $authController = new AuthController($pdo);
    $branchesController = new BranchesController($pdo);
    $companiesController = new CompaniesController($pdo);
    $complaintsController = new ComplaintsController($pdo);
    $productsController = new ProductsController($pdo);
    $userProductsController = new UserProductsController($pdo);
    $productCategoriesController = new ProductCategoriesController($pdo);

    switch ($uri) {
        // Auth Routes
        case 'auth/register':
            if ($method === 'POST') {
                $authController->register();
            }
            break;
        case 'auth/login':
            if ($method === 'POST') {
                $authController->login();
            }
            break;

        // Products Routes
        case 'products/index':
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $productsController->index();
            }
            break;
        case 'products/create':
            if ($method === 'POST') {
                AuthMiddleware::checkRole('admin');
                $productsController->create();
            }
            break;
        case (preg_match('/^products\/show\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $productsController->show($matches[1]);
            }
            break;
        case (preg_match('/^products\/update\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'PUT') {
                AuthMiddleware::checkRole('admin');
                $productsController->update($matches[1]);
            }
            break;
        case (preg_match('/^products\/delete\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'DELETE') {
                AuthMiddleware::checkRole('admin');
                $productsController->delete($matches[1]);
            }
            break;

        // Branches Routes
        case 'branches/index':
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $branchesController->index();
            }
            break;
        case 'branches/create':
            if ($method === 'POST') {
                AuthMiddleware::checkRole('admin');
                $branchesController->create();
            }
            break;
        case (preg_match('/^branches\/show\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $branchesController->show($matches[1]);
            }
            break;
        case (preg_match('/^branches\/update\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'PUT') {
                AuthMiddleware::checkRole('admin');
                $branchesController->update($matches[1]);
            }
            break;
        case (preg_match('/^branches\/delete\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'DELETE') {
                AuthMiddleware::checkRole('admin');
                $branchesController->delete($matches[1]);
            }
            break;

        // Companies Routes
        case 'companies/index':
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $companiesController->index();
            }
            break;
        case 'companies/create':
            if ($method === 'POST') {
                AuthMiddleware::checkRole('admin');
                $companiesController->create();
            }
            break;
        case (preg_match('/^companies\/show\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $companiesController->show($matches[1]);
            }
            break;
        case (preg_match('/^companies\/update\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'PUT') {
                AuthMiddleware::checkRole('admin');
                $companiesController->update($matches[1]);
            }
            break;
        case (preg_match('/^companies\/delete\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'DELETE') {
                AuthMiddleware::checkRole('admin');
                $companiesController->delete($matches[1]);
            }
            break;

        // UserProducts Routes
        case 'userproducts/index':
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $userProductsController->index();
            }
            break;
        case 'userproducts/create':
            if ($method === 'POST') {
                AuthMiddleware::authenticate();
                $userProductsController->create();
            }
            break;
        case (preg_match('/^userproducts\/delete\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'DELETE') {
                AuthMiddleware::authenticate();
                $userProductsController->delete($matches[1]);
            }
            break;

        // Complaints Routes
        case 'complaints/create':
            if ($method === 'POST') {
                AuthMiddleware::authenticate();
                $complaintsController->create();
            }
            break;
        case 'complaints/index': // المسار الجديد لعرض الشكاوى
            if ($method === 'GET') {
                AuthMiddleware::checkRole('admin'); // حماية المسار للمشرفين فقط
                $complaintsController->index();
            }
            break;

        // ProductCategories Routes
        case 'productcategories/index':
            if ($method === 'GET') {
                AuthMiddleware::authenticate();
                $productCategoriesController->index();
            }
            break;
        case 'productcategories/create':
            if ($method === 'POST') {
                AuthMiddleware::checkRole('admin');
                $productCategoriesController->create();
            }
            break;
        case (preg_match('/^productcategories\/update\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'PUT') {
                AuthMiddleware::checkRole('admin');
                $productCategoriesController->update($matches[1]);
            }
            break;
        case (preg_match('/^productcategories\/delete\/(\d+)$/', $uri, $matches) ? true : false):
            if ($method === 'DELETE') {
                AuthMiddleware::checkRole('admin');
                $productCategoriesController->delete($matches[1]);
            }
            break;

        default:
            http_response_code(404);
            echo json_encode(["message" => "Not Found"]);
            break;
    }
}