<?php
// helpers/jwt_helper.php

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../config/jwt.php';

function generate_jwt($user_data) {
    $issued_at = time();
    $expiration_time = $issued_at + (3600 * 24); // 24 hours
    $payload = [
        'iat' => $issued_at,
        'exp' => $expiration_time,
        'iss' => JWT_ISSUER,
        'aud' => JWT_AUDIENCE,
        'data' => $user_data
    ];

    return JWT::encode($payload, JWT_SECRET_KEY, 'HS256');
}

function validate_jwt($jwt) {
    try {
        $key = new Key(JWT_SECRET_KEY, 'HS256');
        $decoded = JWT::decode($jwt, $key);
        return (array) $decoded->data;
    } catch (Exception $e) {
        return false;
    }
}
?>