<?php
// controllers/UserProductsController.php

require_once __DIR__ . '/../config/connect.php';
require_once __DIR__ . '/../middlewares/AuthMiddleware.php';

class UserProductsController {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getUserProducts() {
        // جلب المنتجات المرتبطة بالمستخدم الحالي المصدق
        $user_data = AuthMiddleware::authenticate();

        try {
            $stmt = $this->pdo->prepare("
                SELECT p.id, p.name, p.description, p.price, p.stock_quantity
                FROM UserProducts up
                JOIN Products p ON up.product_id = p.id
                WHERE up.user_id = ?
            ");
            $stmt->execute([$user_data['id']]);
            $products = $stmt->fetchAll();
            echo json_encode(["status" => "success", "data" => $products]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function create() {
      
        // ربط منتج بمستخدم
        $user_data = AuthMiddleware::authenticate();
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['product_id'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required field: product_id."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("INSERT INTO UserProducts (user_id, product_id) VALUES (?, ?)");
            $stmt->execute([$user_data['id'], $data['product_id']]);
            echo json_encode(["status" => "success", "message" => "Product linked to user successfully."]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
}
?>