<?php
// controllers/ProductsController.php

require_once __DIR__ . '/../config/connect.php';

class ProductsController {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function index() {
        // جلب جميع المنتجات
        try {
            $stmt = $this->pdo->query("SELECT * FROM Products");
            $products = $stmt->fetchAll();
            echo json_encode(["status" => "success", "data" => $products]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }

    public function show($id) {
        // جلب منتج محدد بواسطة المعرف (ID)
        try {
            $stmt = $this->pdo->prepare("SELECT * FROM Products WHERE id = ?");
            $stmt->execute([$id]);
            $product = $stmt->fetch();

            if ($product) {
                echo json_encode(["status" => "success", "data" => $product]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Product not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }

    public function create() {
      AuthMiddleware::checkRole('admin');
        // إنشاء منتج جديد
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['name']) || !isset($data['price'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("INSERT INTO Products (name, description, price, stock_quantity) VALUES (?, ?, ?, ?)");
            $stmt->execute([
                $data['name'], 
                $data['description'] ?? null, 
                $data['price'], 
                $data['stock_quantity'] ?? 0
            ]);

            echo json_encode(["status" => "success", "message" => "Product created successfully.", "id" => $this->pdo->lastInsertId()]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function update($id) {
      AuthMiddleware::checkRole('admin');
        // تحديث منتج موجود
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['name']) || !isset($data['price'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("UPDATE Products SET name = ?, description = ?, price = ?, stock_quantity = ? WHERE id = ?");
            $stmt->execute([
                $data['name'], 
                $data['description'] ?? null, 
                $data['price'], 
                $data['stock_quantity'] ?? 0,
                $id
            ]);

            echo json_encode(["status" => "success", "message" => "Product updated successfully."]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function delete($id) {
      AuthMiddleware::checkRole('admin');
        // حذف منتج
        try {
            $stmt = $this->pdo->prepare("DELETE FROM Products WHERE id = ?");
            $stmt->execute([$id]);

            if ($stmt->rowCount() > 0) {
                echo json_encode(["status" => "success", "message" => "Product deleted successfully."]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Product not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
}
?>