<?php
// controllers/ProductCategoriesController.php

require_once __DIR__ . '/../config/connect.php';

class ProductCategoriesController {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function index() {
        // جلب جميع فئات المنتجات
        try {
            $stmt = $this->pdo->query("SELECT * FROM ProductCategories");
            $categories = $stmt->fetchAll();
            echo json_encode(["status" => "success", "data" => $categories]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }

    public function show($id) {
        // جلب فئة منتج محددة بواسطة المعرف (ID)
        try {
            $stmt = $this->pdo->prepare("SELECT * FROM ProductCategories WHERE id = ?");
            $stmt->execute([$id]);
            $category = $stmt->fetch();

            if ($category) {
                echo json_encode(["status" => "success", "data" => $category]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Product category not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function create() {
      AuthMiddleware::checkRole('admin');
        // إنشاء فئة منتج جديدة
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['name'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required field: name."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("INSERT INTO ProductCategories (name, parent_id) VALUES (?, ?)");
            $stmt->execute([
                $data['name'], 
                $data['parent_id'] ?? null
            ]);

            echo json_encode(["status" => "success", "message" => "Product category created successfully.", "id" => $this->pdo->lastInsertId()]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function delete($id) {
      AuthMiddleware::checkRole('admin');
        // حذف فئة منتج
        try {
            $stmt = $this->pdo->prepare("DELETE FROM ProductCategories WHERE id = ?");
            $stmt->execute([$id]);

            if ($stmt->rowCount() > 0) {
                echo json_encode(["status" => "success", "message" => "Product category deleted successfully."]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Product category not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
}
?>