<?php
// controllers/CompaniesController.php

require_once __DIR__ . '/../config/connect.php';

class CompaniesController {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function index() {
        // جلب جميع الشركات
        try {
            $stmt = $this->pdo->query("SELECT * FROM Companies");
            $companies = $stmt->fetchAll();
            echo json_encode(["status" => "success", "data" => $companies]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }

    public function show($id) {
        // جلب شركة محددة بواسطة المعرف (ID)
        try {
            $stmt = $this->pdo->prepare("SELECT * FROM Companies WHERE id = ?");
            $stmt->execute([$id]);
            $company = $stmt->fetch();

            if ($company) {
                echo json_encode(["status" => "success", "data" => $company]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Company not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function create() {
      AuthMiddleware::checkRole('admin');
        // إنشاء شركة جديدة
        $data = json_decode(file_get_contents('php://input'), true);

        // تعديل التحقق ليتناسب مع الحقول الجديدة
        if (!isset($data['name']) || !isset($data['country']) || !isset($data['website'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields: name, country, and website."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("INSERT INTO Companies (name, country, website) VALUES (?, ?, ?)");
            $stmt->execute([$data['name'], $data['country'], $data['website']]);
            echo json_encode(["status" => "success", "message" => "Company created successfully.", "id" => $this->pdo->lastInsertId()]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function update($id) {
      AuthMiddleware::checkRole('admin');
        // تحديث شركة موجودة
        $data = json_decode(file_get_contents('php://input'), true);

        // تعديل التحقق ليتناسب مع الحقول الجديدة
        if (!isset($data['name']) || !isset($data['country']) || !isset($data['website'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields: name, country, and website."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("UPDATE Companies SET name = ?, country = ?, website = ? WHERE id = ?");
            $stmt->execute([$data['name'], $data['country'], $data['website'], $id]);
            echo json_encode(["status" => "success", "message" => "Company updated successfully."]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function delete($id) {
      AuthMiddleware::checkRole('admin');
        // حذف شركة
        try {
            $stmt = $this->pdo->prepare("DELETE FROM Companies WHERE id = ?");
            $stmt->execute([$id]);

            if ($stmt->rowCount() > 0) {
                echo json_encode(["status" => "success", "message" => "Company deleted successfully."]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Company not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
}
?>